<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.

/**
 *
 * Plugin path finder
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if (!function_exists('cs_uwac_plugin_get_path_locate')){
	function cs_uwac_plugin_get_path_locate() {
		$parent_dirname = realpath(dirname(__FILE__) . '/../..');
		// $dirname        = wp_normalize_path( dirname( __FILE__ ) );
		$dirname 		= wp_normalize_path($parent_dirname);

		$plugin_dir     = wp_normalize_path( WP_PLUGIN_DIR );
		$located_plugin = ( preg_match( '#'. $plugin_dir .'#', $dirname ) ) ? true : false;
		$directory      = ( $located_plugin ) ? $plugin_dir : get_template_directory();
		$directory_uri  = ( $located_plugin ) ? WP_PLUGIN_URL : get_template_directory_uri();
		$basename       = str_replace( wp_normalize_path( $directory ), '', $dirname );
		$dir            = $directory . $basename;
		$uri            = $directory_uri . $basename;

		return apply_filters( 'cs_uwac_plugin_get_path_locate', array(
			'basename' => wp_normalize_path( $basename ),
			'dir'      => wp_normalize_path( $dir ),
			'uri'      => $uri
		) );
	}
}


/**
 * Plugin is Network Activated
 * 
 * @since 1.0.0
 */
if (!function_exists('cs_uwac_is_network_active')){
	function cs_uwac_is_network_active() {
		// Makes sure the plugin is defined before trying to use it
		if (!function_exists( 'is_plugin_active_for_network' ) ) {
			require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}
		
		if (is_plugin_active_for_network( 'uwac/uwac.php' ) ) {
			// Plugin is activated
			return true;
		}

		return false;
	}
}


/**
 * Functions to Add, Update and Get Settings
 *
 * @since 1.0.0
 */
if (!function_exists('cs_add_option')){
	function cs_add_option($variable, $default = false) {
		if (cs_is_network_active()) {
			add_site_option($variable, $default);
		} else {
			add_option($variable, $default);
		}
	}
}
if (!function_exists('cs_update_option')){
	function cs_update_option($variable, $default = false) {
		if (cs_is_network_active()) {
			update_site_option($variable, $default);
		} else {
			update_option($variable, $default);
		}
	}
}
if (!function_exists('cs_get_option')){
	function cs_get_option($variable) {
		if (cs_is_network_active()) {
			return get_site_option($variable);
		} else {
			return get_option($variable);
		}
	}
}


/**
 * Get Plugin Settings
 * 
 * Use CSSFramework Instance "unique" (option_array setting) to get plugin specific settings
 * With the unique field_id
 *
 * @since 1.0.0
 */
if (!function_exists('cs_uwac_get_settings')){
	function cs_uwac_get_settings($variable = false, $options = 'cs-uwac'){
		if (cs_uwac_is_network_active()) {
			// $settings 	= get_site_option($options); // To get network wide settings
			$settings 	= get_option($options);
			$output 	= $settings;
			if (!empty($settings) && isset($variable)){
				$output 	= cs_search_settings_array($settings,$variable);
			}
			return $output;
		} else {
			$settings 	= get_option($options);
			$output 	= $settings;
			if (!empty($settings) && isset($variable)){
				$output 	= cs_search_settings_array($settings,$variable);
			}
			return $output;
		}
	}
}


/**
 * Get User Type
 *
 * @return void
 */
if (!function_exists('cs_get_user_type')){
	function cs_get_user_type() {
		$get_admin_menumng_page = cs_get_option("framework_option_to_know_when_loading_lkasdklajsdlkjdcmlakxalksdxa", "enable");

		$enablemenumng = true;
		if ((is_super_admin() || current_user_can('manage_options')) && $get_admin_menumng_page == "disable") {
			$enablemenumng = false;
		}
		return true;
	}
}


/**
 * Helper Function to search plugin settings with the unique field_id
 *
 * @since 1.0.0
 */
if (!function_exists('cs_search_settings_array')){
	function cs_search_settings_array( array $array, $search ){
		while( $array ) {
			if ( isset( $array[ $search ] ) ) { 
				return $array[ $search ]; 
			}
			$segment = array_shift( $array );
			if( is_array( $segment ) ) {
				if( $return = cs_search_settings_array( $segment, $search ) ) {
					return $return;
				}
			}
		}
		return false;
	}
}


/**
 * Search a target on a multidimensional array and return index of target
 * 
 * - Used on Admin menu manager
 * 
 * @since 1.0.0
 */
if (!function_exists('cs_search_multi_array')){
	function cs_search_multi_array($array,$key,$target){
		$output = false;
		if (is_array($array) && isset($key) && isset($target)){
			$output = array_search(
				$target,
				array_filter(
					array_combine(
						array_keys($array),
						array_column(
							$array, $key
						)
					)
				)
			);
		}
		return $output;
	}
}


/**
 * Search a multidimensional array for an id
 * 
 * @since 1.0.0
 */
if (!function_exists('cs_search_array_for_id')){
	function cs_search_array_for_id($array,$needkey,$target) {
		foreach ($array as $key => $val) {
			if ($val[$needkey] === $target) {
				return $key;
			}
		}
		return null;
	}
}
/**
 * Search a multidimensional array for all ids
 * @description Same as cs_search_array_for_id() but returns an array with all the ids of all the matches...
 * 
 * @since 1.1.0
 */
if (!function_exists('cs_search_array_for_ids')){
	function cs_search_array_for_ids($array,$needkey,$target) {
		$output = array();
		foreach ($array as $key => $val) {
			if ($val[$needkey] === $target) {
				$output[] = $key;
			}
		}
		return ($output) ? $output : null;
	}
}


/**
 * Insert New Item in array
 * A function that can insert at both integer and string positions:
 * 
 * @since 1.0.0
 */
if (!function_exists('cs_array_insert')){
	function cs_array_insert(&$array, $position, $insert){
		if (is_int($position)) {
			cs_array_splice_assoc($array, $position, 0, $insert);
		} else {
			$pos   = array_search($position, array_keys($array));
			$array = array_merge(
				array_slice($array, 0, $pos, TRUE),
				$insert,
				array_slice($array, $pos, NULL, TRUE)
			);
		}
	}
}
if (!function_exists('cs_array_splice_assoc')){
	function cs_array_splice_assoc(&$input, $offset, $length, $replacement) {
		$replacement = (array) $replacement;
		$key_indices = array_flip(array_keys($input));
		if (isset($input[$offset]) && is_string($offset)) {
			$offset = $key_indices[$offset];
		}
		if (isset($input[$length]) && is_string($length)) {
			$length = $key_indices[$length] - $offset;
		}
	
		$input = array_slice($input, 0, $offset, TRUE)
			+ $replacement
			+ array_slice($input, $offset + $length, NULL, TRUE);
	}
}


/**
 * Check User Roles
 * 
 * @since 1.1.0
 */
if (!function_exists('cs_get_user_roles_by_user_id')){
	function cs_get_user_roles_by_user_id($user_id){
		$user = get_userdata( $user_id );
		return empty( $user ) ? array() : $user->roles;
	}
}
if (!function_exists('cs_is_user_in_role')){
	function cs_is_user_in_role($user_id, $role){
		return in_array( $role, get_user_roles_by_user_id($user_id)) ;
	}
}
if (!function_exists('cs_get_current_user_roles')){
	function cs_get_current_user_roles(){
		if (is_user_logged_in()){
			$user = wp_get_current_user();
			return (array) $user->roles;
		} else {
			return array();
		}
	}
}
if (!function_exists('cs_is_current_user_in_role')){
	function cs_is_current_user_in_role($role){
		if (is_user_logged_in()){
			$user = wp_get_current_user();
			return in_array($role, (array) $user->roles );
		} else {
			return array();
		}
	}
}


/**
 * 
 * Helper Functions
 * 
 */
if (!function_exists('cs_removeslashes')){
	function cs_removeslashes($string) {
		$string = implode("", explode("\\", $string));
		return stripslashes(trim($string));
	}
}

if (!function_exists('cs_reformatstring')){
	function cs_reformatstring($str) {
		$str = htmlspecialchars($str, ENT_QUOTES);
		$str = cs_removeslashes($str);
		return $str;
	}
}

if (!function_exists('cs_sanitize')){
	function cs_sanitize($string){
		return filter_var($string, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
	}
}